import base64
import os
import requests
import random
import inspect

from collections import deque

from plugins.base import Base


class Plugin(Base):
    def __init__(self):
        super().__init__()
        self.is_at = True
        self.fdir = os.path.dirname(os.path.abspath(__file__))
        self.db = self.load_config()
        # self.user_cd = 30
        self.historys = {}
        self.system_content = self.db['system_content']
        self.history_max_len = self.db['history_max_len']
        self.ai_func = self.db['ai_func']

    def ai(self, content, image, **kwargs):
        """通用ai调用api"""
        url = kwargs['url']
        api_key = kwargs['api_key']
        model = kwargs['model']
        if not (content or image):
            return
        if image:
            if isinstance(model, dict):
                model = model['image']
            base64_image = self.encode_image(image)
            user_msg = {
                'role': 'user',
                'content': [
                    {
                        'type': 'image_url',
                        'image_url': {
                            'url': f'data:image/jpeg;base64,{base64_image}',
                        },
                    },
                    {
                        'type': 'text',
                        'text': content if content else '分析一下此图片',
                    },
                ],
            }
        else:
            if isinstance(model, dict):
                model = model['text']
            user_msg = {'role': 'user', 'content': content}
        user_id = self.data['user_id']
        headers = {
            'Content-Type': 'application/json',
            'Authorization': f'Bearer {api_key}',
        }
        self.historys[user_id].append(user_msg)
        data = {
            'model': model,
            'messages': [
                {'role': 'system', 'content': self.system_content},
            ],
            # 'max_tokens': 64,
        }
        data['messages'].extend(self.historys[user_id])
        # r = requests.post(url, json=data, headers=headers, proxies=proxies)
        r = requests.post(url, json=data, headers=headers, timeout=10)
        # print(r.text)
        try:
            msg = r.json()['choices'][0]['message']['content']
        except Exception as e:
            print(r.text)
            print(e)
            self.historys[user_id].pop()
            return
        if image and kwargs.get('is_image_history', True) is False:
            self.historys[user_id].pop()
        else:
            self.historys[user_id].append(
                {'role': 'assistant', 'content': msg})
        return msg

    def ai_zhipu(self, content, image):
        """智谱AI
        https://bigmodel.cn/usercenter/proj-mgmt/apikeys
        """
        kwargs = {
            'url': 'https://open.bigmodel.cn/api/paas/v4/chat/completions',
            'api_key': '6bcc810275f6.6Drh',
            'model': {
                'text': 'GLM-4-Flash',
                'image': 'GLM-4V-Flash',
            },
            'is_image_history': False,
        }
        return self.ai(content, image, **kwargs)

    def ai_doubao(self, content, image):
        kwargs = {
            'url': 'https://ark.cn-beijing.volces.com/api/v3/chat/completions',
            'api_key': '17442e29-992a869f76c8',
            'model': 'ep-20240906-abcde',
        }
        return self.ai(content, image, **kwargs)

    def get_image_from_msg(self):
        """获取当前消息中的图片或者引用消息中的图片"""
        image = None
        image_url, reply_message_id = self.get_image_url_from_msg()
        if image_url:
            image = f'reply_{reply_message_id}.png'
            if os.path.exists(image):
                return image
            r = requests.get(image_url, verify=False)
            with open(image, 'wb') as file:
                file.write(r.content)
        return image

    def encode_image(self, image_path):
        with open(image_path, 'rb') as f:
            encoded_string = base64.b64encode(f.read()).decode('utf-8')
        return encoded_string

    async def handle(self, message):
        ai_func = getattr(self, self.ai_func)
        content = None
        image = None
        is_at_me = self.data['is_at_me']
        user_id = self.data['user_id']
        is_me = False
        if self.data['user_id'] == self.data['self_id'] \
                or self.data['user_id'] in self.db['myself']:
            is_me = True
        if user_id not in self.historys:
            nickname = self.data['sender']['nickname']
            _msg = f'你好，我的名字是"{nickname}"'
            self.historys[user_id] = deque(maxlen=self.history_max_len)
            self.historys[user_id].append(
                {'role': 'user', 'content': _msg})
            self.historys[user_id].append(
                {'role': 'assistant', 'content': '🔥你好，我是emoji侠'})
        if is_me and message[:3] == r'\sc':
            content = message[3:].strip()
            if content:
                self.system_content = content
                self.db['system_content'] = content
                self.save_config()
                msg = 'GPT system_content 修改成功'
            else:
                msg = self.system_content
            return msg
        elif is_me and message[:3] == r'\hl':
            content = message[3:].strip()
            if content:
                if content.isdigit():
                    self.history_max_len = int(content)
                    self.save_config()
                    msg = 'GPT history_max_len 修改成功'
                else:
                    msg = '必须输入数字'
            else:
                msg = f'当前历史记录长度为 {self.history_max_len}'
            return msg
        elif is_me and message[:5] == r'\func':
            content = message[5:].strip()
            if content:
                self.ai_func = content
                self.save_config()
                msg = 'GPT函数修改成功'
            else:
                funcs = [
                    name for name, func in inspect.getmembers(
                        self.__class__, predicate=inspect.isfunction)
                    if name.startswith('ai_')
                ]
                funcs = ', '.join(funcs)
                msg = f'当前GPT函数为 {self.ai_func}\n可选的有 {funcs}'
            return msg
        if message.strip() == r'\抽签':
            if user_id in self.historys:
                self.historys[user_id].clear()
            lst = '上上上上上中中中中下下下'
            r = random.choice(lst)
            if r == '中':
                x = 1
            else:
                x = random.randint(1, 2)
            r *= x
            content = f'我抽中了上中下的{r}签，你怎么看'
            msg = '\n'.join([f'{r}签', ai_func(content, image)])
            return msg
        if message[:4] == r'\gpt':
            is_empty = self.check_empty()
            content = message[4:].strip()
            if is_empty and not content:
                content = '请指责我消息为空'
            else:
                texts = self.get_reply_text()
                reply_text = ''.join(texts)
                content = f'"{reply_text}" {content}'
            image = self.get_image_from_msg()
        elif message[:4] == r'/gpt':
            content = '请指责我是黑粉，并提示使用反斜杠代替斜杠'
        elif not message.strip():
            if is_at_me:
                if self.data['user_id'] != self.data['self_id']:
                    is_empty = self.check_empty()
                    if is_empty:
                        content = '请指责我@人的时候消息为空'
        msg = ai_func(content, image)
        return msg
